document.addEventListener("DOMContentLoaded", function () {
  const aboutBtn = document.getElementById("about-btn");
  const membersBtn = document.getElementById("members-btn");
  const contactBtn = document.getElementById("contact-btn");

  const aboutBox = document.getElementById("about-box");
  const membersBox = document.getElementById("members-box");
  const contactBox = document.getElementById("contact-box");

  const articleCards = document.querySelector(".article-card");

  let currentVisibleBox = articleCards; // نبدأ بعرض articleCards
  let isTransitioning = false; // قفل منع التداخل
  let queuedBox = null; // طابور انتظار للعرض الجديد

  function hideElement(el) {
    return new Promise((resolve) => {
      el.style.opacity = "0";
      setTimeout(() => {
        el.style.visibility = "hidden";
        el.style.display = "none";
        resolve();
      }, 1000); // مدة إخفاء 0.6 ثانية
    });
  }

  function showElement(el) {
    return new Promise((resolve) => {
      el.style.display = "block";
      el.style.visibility = "visible";
      setTimeout(() => {
        el.style.opacity = "1";
        setTimeout(resolve, 500); // مدة إظهار 0.6 ثانية
      }, 50);
    });
  }

  async function processQueue() {
    if (queuedBox) {
      const box = queuedBox;
      queuedBox = null;
      await showPopup(box);
    }
  }

  async function showPopup(boxToShow) {
    if (currentVisibleBox === boxToShow) return;

    if (isTransitioning) {
      queuedBox = boxToShow; // تأجيل الطلب إذا في عرض شغال
      return;
    }

    isTransitioning = true;

    if (currentVisibleBox) {
      await hideElement(currentVisibleBox);
      await showElement(boxToShow);
      currentVisibleBox = boxToShow;
    } else {
      await hideElement(articleCards);
      await showElement(boxToShow);
      currentVisibleBox = boxToShow;
    }

    isTransitioning = false;

    await processQueue(); // تنفيذ أي طلب مؤجل
  }

  async function showArticleCards() {
    if (isTransitioning) return;
    isTransitioning = true;

    if (currentVisibleBox && currentVisibleBox !== articleCards) {
      await hideElement(currentVisibleBox);
      currentVisibleBox = articleCards;
    }
    await showElement(articleCards);

    isTransitioning = false;
  }

  aboutBtn.addEventListener("click", function (e) {
    e.preventDefault();
    showPopup(aboutBox);
  });

  membersBtn.addEventListener("click", function (e) {
    e.preventDefault();
    showPopup(membersBox);
  });

  contactBtn.addEventListener("click", function (e) {
    e.preventDefault();
    showPopup(contactBox);
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const hamburgerBtn = document.getElementById("hamburger-btn");
  const sidebar = document.getElementById("sidebar");
  const mouseEffect = document.querySelector(".mouse-effect");

  hamburgerBtn.addEventListener("click", function () {
    sidebar.classList.toggle("open");
    hamburgerBtn.classList.toggle("active");
  });

  mouseEffect.addEventListener("mousedown", function (event) {
    let offsetX = event.clientX - mouseEffect.offsetLeft;
    let offsetY = event.clientY - mouseEffect.offsetTop;

    function mouseMoveHandler(e) {
      mouseEffect.style.left = e.clientX - offsetX + "px";
      mouseEffect.style.top = e.clientY - offsetY + "px";
    }

    document.addEventListener("mousemove", mouseMoveHandler);
    document.addEventListener(
      "mouseup",
      function () {
        document.removeEventListener("mousemove", mouseMoveHandler);
      },
      { once: true }
    );
  });
});

document.addEventListener("mousemove", function (event) {
  let cursor = document.getElementById("cursor");
  if (cursor) {
    cursor.style.left = event.pageX + "px";
    cursor.style.top = event.pageY + "px";
  }
});

document.addEventListener("DOMContentLoaded", function () {
  const enterScreen = document.getElementById("enter-screen");
  const enterBtn = document.getElementById("enter-btn");
  const backgroundMusic = document.getElementById("background-music");

  enterBtn.addEventListener("click", function () {
    enterScreen.style.opacity = "0";
    setTimeout(() => {
      enterScreen.style.display = "none";
      document.body.classList.add("loaded");
    }, 800);

    backgroundMusic.play();
    backgroundMusic.loop = true;
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const memberCards = document.querySelectorAll(".member-card");

  memberCards.forEach((card) => {
    const popupId = "popup-" + card.getAttribute("data-member");
    const popupBox = document.getElementById(popupId);

    card.addEventListener("click", () => {
      popupBox.classList.add("visible");
    });

    document.addEventListener("mouseup", function (event) {
      if (!card.contains(event.target) && !popupBox.contains(event.target)) {
        popupBox.classList.remove("visible");
      }
    });

    let isDragging = false;
    let dragOffsetX, dragOffsetY;

    popupBox.addEventListener("mousedown", function (event) {
      if (event.target === popupBox) {
        isDragging = true;
        dragOffsetX = event.clientX - popupBox.offsetLeft;
        dragOffsetY = event.clientY - popupBox.offsetTop;
        document.addEventListener("mousemove", dragMove);
      }
    });

    document.addEventListener("mouseup", function () {
      isDragging = false;
      document.removeEventListener("mousemove", dragMove);
    });

    function dragMove(e) {
      if (isDragging) {
        let newX = Math.max(
          0,
          Math.min(e.clientX - dragOffsetX, window.innerWidth - popupBox.offsetWidth)
        );
        let newY = Math.max(
          0,
          Math.min(e.clientY - dragOffsetY, window.innerHeight - popupBox.offsetHeight)
        );
        popupBox.style.left = newX + "px";
        popupBox.style.top = newY + "px";
      }
    }
  });
});

document.addEventListener("mousemove", function (event) {
  const cursor = document.querySelector(".mouse-effect");
  if (cursor) {
    cursor.style.left = event.pageX + "px";
    cursor.style.top = event.pageY + "px";
  }
});
